/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.dialogs;

import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.syncing.core.ISiteConnection;
import com.aptana.ide.syncing.ui.dialogs.Messages;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.util.SWTUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ChooseSiteConnectionDialog
extends TrayDialog
implements SelectionListener {
    private Combo fSiteCombo;
    private Label fSiteDescriptionLabel;
    private Button fRememberMyDecisionButton;
    private ISiteConnection[] fSites;
    private ISiteConnection fSelectedSite;
    private boolean fShowRememberMyDecision;
    private boolean fRememberMyDecision;

    public ChooseSiteConnectionDialog(Shell parent, ISiteConnection[] sites) {
        this(parent, sites, false);
    }

    public ChooseSiteConnectionDialog(Shell parent, ISiteConnection[] sites, boolean showRememberMyDecision) {
        super(parent);
        this.fSites = sites;
        this.fShowRememberMyDecision = showRememberMyDecision;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setHelpAvailable(false);
    }

    public ISiteConnection getSelectedSite() {
        return this.fSelectedSite;
    }

    public boolean isRememberMyDecision() {
        if (this.fShowRememberMyDecision) {
            return this.fRememberMyDecision;
        }
        return false;
    }

    public void setSelectedSite(ISiteConnection site) {
        this.fSelectedSite = site;
    }

    public void setShowRememberMyDecision(boolean show) {
        this.fShowRememberMyDecision = show;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fSiteCombo) {
            this.updateDescriptiveText();
        } else if (source == this.fRememberMyDecisionButton) {
            this.fRememberMyDecision = this.fRememberMyDecisionButton.getSelection();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ChooseSiteConnectionDialog_Title);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        Shell shell = this.getShell();
        Shell parentShell = this.getShell().getParent().getShell();
        SWTUtils.centerAndPack((Shell)shell, (Shell)parentShell);
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp = new Composite(main, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(comp, 131072);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setAlignment(131072);
        label.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)"icons/aptana_dialog_tag.png"));
        label = new Label(comp, 64);
        label.setFont(SWTUtils.getDefaultSmallFont());
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 50;
        gridData.widthHint = 400;
        gridData.horizontalIndent = 5;
        gridData.verticalIndent = 3;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.ChooseSiteConnectionDialog_LBL_Message);
        comp = new Composite(main, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        comp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(comp, 0);
        label.setText(StringUtil.makeFormLabel((String)Messages.ChooseSiteConnectionDialog_LBL_Connection));
        this.fSiteCombo = new Combo(comp, 12);
        this.fSiteCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fSiteCombo.addSelectionListener((SelectionListener)this);
        this.fSiteCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseSiteConnectionDialog.this.validate();
            }
        });
        new Label(comp, 0);
        this.fSiteDescriptionLabel = new Label(comp, 0);
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 450;
        this.fSiteDescriptionLabel.setLayoutData((Object)gridData);
        if (this.fShowRememberMyDecision) {
            this.fRememberMyDecisionButton = new Button(comp, 32);
            this.fRememberMyDecisionButton.setText(Messages.ChooseSiteConnectionDialog_LBL_RememberMyDecision);
            gridData = new GridData(1, 0x1000000, false, false);
            gridData.horizontalSpan = 2;
            this.fRememberMyDecisionButton.setLayoutData((Object)gridData);
            this.fRememberMyDecisionButton.addSelectionListener((SelectionListener)this);
            label = new Label(comp, 64);
            label.setText(Messages.ChooseSiteConnectionDialog_LBL_PropertyPage);
            gridData = new GridData(1, 0x1000000, true, false);
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
        }
        this.initializeDefaultValues();
        return main;
    }

    protected void okPressed() {
        if (!this.validate()) {
            return;
        }
        int index = this.fSiteCombo.getSelectionIndex();
        if (index > -1) {
            this.fSelectedSite = this.fSites[index];
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.fSelectedSite = null;
        super.cancelPressed();
    }

    private boolean validate() {
        boolean success = true;
        if (!SWTUtils.validateCombo((Combo)this.fSiteCombo, (int)0)) {
            success = false;
        }
        return success;
    }

    private void initializeDefaultValues() {
        int currentIndex = 0;
        int selectIndex = 0;
        ISiteConnection[] iSiteConnectionArray = this.fSites;
        int n = this.fSites.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteConnection site = iSiteConnectionArray[n2];
            IConnectionPoint destination = site.getDestination();
            if (destination != null) {
                this.fSiteCombo.add(String.valueOf(site.getName()) + ": " + destination.getName());
                if (site == this.fSelectedSite) {
                    selectIndex = currentIndex;
                }
                ++currentIndex;
            }
            ++n2;
        }
        this.fSiteCombo.select(selectIndex);
        this.updateDescriptiveText();
    }

    private void updateDescriptiveText() {
        int index = this.fSiteCombo.getSelectionIndex();
        if (index == -1) {
            return;
        }
        this.fSelectedSite = this.fSites[index];
        IConnectionPoint source = this.fSelectedSite.getSource();
        IConnectionPoint target = this.fSelectedSite.getDestination();
        try {
            this.fSiteDescriptionLabel.setText(String.valueOf(FileUtil.compressPath((String)source.getRoot().toString(), (int)25)) + " <-> " + FileUtil.compressPath((String)target.getRoot().toString(), (int)25));
        }
        catch (CoreException e) {
            this.fSiteDescriptionLabel.setText(String.valueOf(FileUtil.compressPath((String)source.getName(), (int)25)) + " <-> " + FileUtil.compressPath((String)target.getName(), (int)25));
        }
    }
}

